/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.action.CertificateImport;
import de.willuhn.jameica.gui.internal.action.SystemCertificates;
import de.willuhn.jameica.gui.internal.controller.SettingsControl;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BootstrapSettings;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class Settings
extends AbstractView
implements Extendable {
    private MessageConsumer mc = new MyMessageConsumer();
    private static Integer lastActiveTab = null;
    private TabFolder folder = null;

    @Override
    public void bind() throws Exception {
        I18N i18n = Application.getI18n();
        GUI.getView().setTitle(i18n.tr("Einstellungen"));
        final SettingsControl control = new SettingsControl(this);
        TabGroup system = new TabGroup(this.getTabFolder(), i18n.tr("System"), true);
        system.addHeadline(i18n.tr("System-Einstellungen"));
        system.addLabelPair(i18n.tr("Sprache"), (Input)control.getLocale());
        system.addLabelPair(i18n.tr("Log-Level"), control.getLogLevel());
        if (!BootstrapSettings.getAskWorkdir()) {
            system.addInput(control.getAskWorkdir());
        }
        system.addHeadline(i18n.tr("Proxy-Einstellungen"));
        system.addCheckbox(control.getUseSystemProxy(), i18n.tr("System-Einstellungen verwenden"));
        ColumnLayout cl = new ColumnLayout(system.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(cl.getComposite());
        left.addInput(control.getProxyHost());
        left.addInput(control.getHttpsProxyHost());
        SimpleContainer right = new SimpleContainer(cl.getComposite());
        right.addInput(control.getProxyPort());
        right.addInput(control.getHttpsProxyPort());
        system.addHeadline(i18n.tr("Installierte SSL-Zertifikate"));
        system.addPart(control.getCertificates());
        system.addInput(control.getTrustJavaCerts());
        ButtonArea certButtons = new ButtonArea();
        certButtons.addButton(i18n.tr("Aussteller-Zertifikate von Java anzeigen"), new SystemCertificates(), null, false, "stock_keyring.png");
        certButtons.addButton(i18n.tr("Zertifikat importieren"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                new CertificateImport().handleAction(context);
                GUI.startView(GUI.getCurrentView().getClass(), GUI.getCurrentView().getCurrentObject());
            }
        }, null, false, "document-open.png");
        system.addButtonArea(certButtons);
        TabGroup plugins = new TabGroup(this.getTabFolder(), i18n.tr("Plugins"), false, 1);
        control.getPlugins().paint(plugins.getComposite());
        TabGroup lnfGroup = new TabGroup(this.getTabFolder(), i18n.tr("Look and Feel"));
        lnfGroup.addLabelPair(i18n.tr("Hintergrundfarbe von Pflichtfeldern"), control.getColorMandatoryBG());
        lnfGroup.addCheckbox(control.getLabelMandatory(), i18n.tr("Auch den Text vor diesen Pflichtfeldern (Label) hervorheben"));
        lnfGroup.addSeparator();
        lnfGroup.addLabelPair(i18n.tr("Textfarbe von Fehler- und Warnmeldungen"), control.getColorError());
        lnfGroup.addLabelPair(i18n.tr("Textfarbe von Erfolgsmeldungen"), control.getColorSuccess());
        File f = new File("lib/splash.jar");
        if (f.exists() && f.isFile() && f.canRead()) {
            lnfGroup.addCheckbox(control.getRandomSplash(), i18n.tr("Zufallsbild in Splashscreen anzeigen"));
        }
        lnfGroup.addHeadline(i18n.tr("System-Tray Symbol"));
        lnfGroup.addInput(control.getSystray());
        lnfGroup.addInput(control.getMinimizeToSystray());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Zur\u00fccksetzen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                control.handleRestore();
            }
        }, null, false, "edit-undo.png");
        buttons.addButton(i18n.tr("Speichern"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, false, "document-save.png");
        buttons.paint(this.getParent());
        Application.getMessagingFactory().getMessagingQueue(this.getExtendableID()).registerMessageConsumer(this.mc);
    }

    private void focus() {
        TabFolder folder = this.getTabFolder();
        if (folder == null || folder.isDisposed()) {
            return;
        }
        Integer activeTab = lastActiveTab;
        Object context = this.getCurrentObject();
        if (context != null) {
            Object o;
            if (context instanceof Integer) {
                activeTab = (Integer)context;
            } else if (context instanceof String && (o = folder.getData((String)context)) instanceof TabItem) {
                folder.setSelection((TabItem)o);
                return;
            }
        }
        if (activeTab != null) {
            folder.setSelection(activeTab.intValue());
        }
    }

    public TabFolder getTabFolder() {
        if (this.folder != null) {
            return this.folder;
        }
        this.folder = new TabFolder(this.getParent(), 0);
        this.folder.setLayoutData((Object)new GridData(1808));
        return this.folder;
    }

    @Override
    public void unbind() throws ApplicationException {
        Application.getMessagingFactory().getMessagingQueue(this.getExtendableID()).unRegisterMessageConsumer(this.mc);
        lastActiveTab = this.getTabFolder().getSelectionIndex();
    }

    @Override
    public String getExtendableID() {
        return this.getClass().getName();
    }

    @Override
    public boolean canBookmark() {
        return false;
    }

    @Override
    public boolean canAttach() {
        return false;
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Settings.this.focus();
                }
            });
        }
    }
}

